/* sketch for EEG Sampler's firmware, to use an Arduino Nano.
   Written by Jim Rowe (Silicon Chip)
   Last revised 21/06/2018 at 6:45 am */
   
  byte inCmdByte = 0;    // for incoming serial data (command) from PC
  byte SmplFlag = 0;     // flag for sampling (1 = go, 0 = stop)
  int Sample[3];         // define 3x integer array for sample readings
  
void setup()
{
  pinMode(3, OUTPUT);   // declares IO3 as a digital output pin (for LED2)
  digitalWrite(3, LOW); // and set it low so LED2 is initially off
  Serial.begin(115200); // start up serial comms to PC at 115200 baud
}

unsigned long cur_time, last_time;

void loop()
{
  cur_time = millis();
  if (SmplFlag == 1 && cur_time - last_time >= 5)     // now if sample flag is raised,
  {                      // read samples & send them off to PC
    Sample[0] = analogRead(A0); // read Ch1 sample
    Serial.println(Sample[0]);  // & send it off
    Sample[1] = analogRead(A1); // then read Ch2 sample
    Serial.println(Sample[1]);  // & send it off
    Sample[2] = analogRead(A2); // then read Ch3 sample
    Serial.println(Sample[2]);  // & send it off
    last_time += 5;
//    SmplFlag = 0;               // finally clear sample flag
  }      
  if (Serial.available() > 0)   // now if serial data has arrived,
  {
    inCmdByte = Serial.read();    // read the command byte
    
    if (inCmdByte == 'T' || inCmdByte == 't')
    {
      SmplFlag = 1;       // raise sampling flag, to begin sampling
      last_time = millis();
      digitalWrite(3, HIGH);  // and turn on LED2
    }
    if (inCmdByte == 'S' || inCmdByte == 's')
    {
      SmplFlag = 0;         // lower sampling flag, to stop sampling
      digitalWrite(3, LOW);   // and turn off LED2
    }
  }
}   // end of loop() code and sketch
     

